// FiniteState.h	by Mark Szymczyk

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#ifndef STATE_TRANSITION
    #include "StateTransition.h"
#endif

#define FINITE_STATE

// The states an enemy can be in during the game
/*
enum StateType
{
    kStandingState = 0, 
	kPatrollingState, 
	kChasingState,
	kFleeingState,
	kStatesInGame
};
*/

class FiniteState
{
	public:
        // This is an array of state transitions.
        // Make it public because it is difficult
        // to retrieve an array with an accessor function.
        StateTransitionPtr transitionTable;
        
    protected:
		short transitionTotal;
        StateType state;
        
    public:
        // Constructor and destructor
        FiniteState(void);
		FiniteState(const FiniteState& theState);	// Copy constructor
        virtual ~FiniteState(void);

		// Overload assignment operator
		FiniteState& operator= (const FiniteState& theState);
        
        // Accessors
        short GetTransitionTotal(void);
        void SetTransitionTotal(short theTotal);
        
        StateType GetState(void);
        void SetState(StateType theState);
        
        // Filling the transition table
        void FillTransitionTable(StateTransitionPtr tableToAdd);
        void AddTransition(StateTransitionPtr transitionToAdd, short index);
        
        // Dealing with transitions
        StateType HandleTransition(StateTransitionType theTransition);
};
	
typedef FiniteState* FiniteStatePtr;
typedef FiniteState** FiniteStateHandle;
