// ConfigurationDialog.h	by Mark Szymczyk
// Book version

#ifndef MOVABLE_MODAL_DIALOG
	#include "MovableModalDialog.h"
#endif

#ifndef INPUT_CONTROLLER
	#include "InputController.h"
#endif

#ifndef __COREFOUNDATION__
    #include <CoreFoundation/CoreFoundation.h>
#endif

#define CONFIGURATION_DIALOG

class ConfigurationDialog: public MovableModalDialog
{
	protected:
        InputControllerPtr currentController;
        // We need this data member so we can
        // restore the input device if the player
        // chooses a different controller, then cancels
        // the selection.
        InputDevicePtr storedDevice;
	
    public:
		ConfigurationDialog(void);
        ~ConfigurationDialog(void);
		
        // Accessors
        InputControllerPtr GetCurrentController(void);
        void SetCurrentController(InputControllerPtr theController);

        InputDevicePtr GetStoredDevice(void);
        void SetStoredDevice(InputDevicePtr theDevice);
        
        
		// Functions to override from MovableModalDialog
		virtual void Create(short resourceID);
		virtual void HandleKeyDown(EventRecord* event);
		virtual void DoItemHit(short theItem);

        // Handling specific items in the configuration dialog box
        void HandleOKSelection(void);
        void HandleCancelSelection(void);
        void HandleControllerMenuSelection(void);
        void HandleXAxisMenuSelection(void);
        void HandleYAxisMenuSelection(void);
        void HandleAttackMenuSelection(void);
        void HandleChangeWeaponMenuSelection(void);
        
        // Menu filling functions
        void FillControlMenus(InputControllerPtr controller);
        void FillChooseControllerMenu(InputControllerPtr controller);
        void FillXAxisMenu(InputControllerPtr controller);
        void FillYAxisMenu(InputControllerPtr controller);
        void FillAttackMenu(InputControllerPtr controller);
        void FillChangeWeaponMenu(InputControllerPtr controller);
        
        // Setting the control needs from the dialog box
        void UpdateControllerDevice(void);
        void SetControlNeeds(void);
        void SetXAxisControlNeed(void);
        void SetYAxisControlNeed(void);
        void SetAttackControlNeed(void);
        void SetChangeWeaponControlNeed(void);
};

typedef ConfigurationDialog* ConfigurationDialogPtr;
typedef ConfigurationDialog** ConfigurationDialogHandle;
		
// constants
const short kConfigurationDialogID = 128;
const short kChooseControllerMenuID = 300;
const short kXAxisMenuID = 301;
const short kYAxisMenuID = 302;
const short kAttackMenuID = 303;
const short kChangeWeaponMenuID = 304;
const short kEnable = 0;
const short kDisable = 255;
const short kFirstItem = 1;
const short kInsertAtStartOfMenu = 0;
const short kStringsMatch = 0;

// Item numbers for the dialog box
// ok = 1 and cancel = 2.  Those are predefined
const short kChooseControllerMenu = 3;
const short kXAxisMenu = 4;
const short kYAxisMenu = 5;
const short kAttackMenu = 6;
const short kChangeWeaponMenu = 7;		

// Keyboard constants
const char kReturnKeyCharCode = 0x0D;
const char kEnterKeyCharCode = 0x03;
const char kEscapeKeyCharCode = 0x1B;
