// Blitter.h		Written by Mark Szymczyk
// Book version

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#define BLITTER


// The Blitter handles the drawing from one buffer
// to another.
class Blitter
{
	protected:
		CGrafPtr sourceBuffer;
		CGrafPtr destinationBuffer;
		Rect sourceRect;
		Rect destinationRect;
		short drawingMode;
		long transparentColor;		
	
	public:
		Blitter(void);
		
		// Accessor functions
		CGrafPtr GetSourceBuffer(void);          	
		void SetSourceBuffer(CGrafPtr theBuffer);	

		CGrafPtr GetDestinationBuffer(void);           	
		void SetDestinationBuffer(CGrafPtr theBuffer);	
		
		Rect GetSourceRect(void);         	
		void SetSourceRect(Rect theRect);	

		Rect GetDestinationRect(void);          	
		void SetDestinationRect(Rect theRect);
		
		short GetDrawingMode(void);
		void SetDrawingMode(short theMode);	

		long GetTransparentColor(void);
		void SetTransparentColor(long theColor);	

		virtual void Initialize(CGrafPtr theBuffer, short transferMode);
		virtual void Setup(CGrafPtr destBuffer, Rect sourceRect, Rect destRect);
		virtual void SetupSourceRect(Rect theSource);
		virtual void SetupDestinationRect(Rect theDestination);
		virtual void DrawImageToOffscreenBuffer(void);
		virtual void DrawImageToScreen(void);
		
        virtual void FlushBackBuffer(void);
};

typedef Blitter* BlitterPtr;
typedef Blitter** BlitterHandle;

// Constants
const Rect kEmptyRect = {0, 0, 0, 0};