// Blitter.cp		Written by Mark Szymczyk
// Book Version

#ifndef BLITTER
	#include "Blitter.h"
#endif

// Constructor
Blitter::Blitter(void)
{
	sourceBuffer = nil;
	destinationBuffer = nil;
    SetSourceRect(kEmptyRect);
    SetDestinationRect(kEmptyRect);
    SetDrawingMode(0);
    SetTransparentColor(0);
}

// Accessors
CGrafPtr Blitter::GetSourceBuffer(void)            	
{ 
	return sourceBuffer; 
}

void Blitter::SetSourceBuffer(CGrafPtr theBuffer)	
{ 
	sourceBuffer = theBuffer; 
}

CGrafPtr Blitter::GetDestinationBuffer(void)            	
{ 
	return destinationBuffer; 
}
		
void Blitter::SetDestinationBuffer(CGrafPtr theBuffer)	
{ 
	destinationBuffer = theBuffer; 
}
		
Rect Blitter::GetSourceRect(void)          	
{ 
	return sourceRect; 
}

void Blitter::SetSourceRect(Rect theRect)	
{ 
	sourceRect = theRect; 
}

Rect Blitter::GetDestinationRect(void)          	
{
	return destinationRect; 
}
		
void Blitter::SetDestinationRect(Rect theRect)	
{ 
	destinationRect = theRect; 
}

short Blitter::GetDrawingMode(void)
{
 	return drawingMode;
}

void Blitter::SetDrawingMode(short theMode)
{
	drawingMode = theMode;
}

long Blitter::GetTransparentColor(void)
{
 	return transparentColor;
}

void Blitter::SetTransparentColor(long theColor)
{
	transparentColor = theColor;
}


// Blitter member functions
void Blitter::Initialize(CGrafPtr theBuffer, short transferMode)
{
	// Sets up the parts of the sprite blitter that
	// stay the same from frame to frame.

	SetSourceBuffer(theBuffer);
	ForeColor(blackColor);
	BackColor(whiteColor);
	SetTransparentColor(whiteColor);
	SetDrawingMode(transferMode);

}

void Blitter::Setup(CGrafPtr destBuffer, Rect sourceRect, Rect destRect)
{
	// Sets up the parts of the sprite blitter that
	// change from frame to frame
	SetupSourceRect(sourceRect);
	SetDestinationBuffer(destBuffer);	
	SetupDestinationRect(destRect);
	
}

void Blitter::SetupSourceRect(Rect theSource)
{	
	SetSourceRect(theSource);	
}

void Blitter::SetupDestinationRect(Rect theDestination)
{
	SetDestinationRect(theDestination);	
} 

void Blitter::DrawImageToOffscreenBuffer(void)
{
	// When drawing into an offscreen GWorld, you should
	// lock its pixels for safety.  Because we're drawing
	// from a GWorld to another GWorld in this program, we need
	// two drawing functions, one for drawing to a GWorld and
	// one for drawing to the screen.  The only difference
	// between the two is that this function locks the
	// destination pixels and the DrawImageToScreen()
	// function does not.

	// Make sure the source and destination buffers exist.
	CGrafPtr theSource = GetSourceBuffer();
	CGrafPtr theDestination = GetDestinationBuffer();
	if ((theSource == nil) || (theDestination == nil))
		return;
		
	CGrafPtr oldPort;
	GDHandle oldGDevice;

	// Save previous drawing area
	GetGWorld (&oldPort, &oldGDevice);

	// Set drawing area to the screen
	SetGWorld (theDestination, GetMainDevice());
	
	// Lock the pixels
	PixMapHandle thePixMap = GetGWorldPixMap(theSource);	
	Boolean canLockPixels = LockPixels(thePixMap);

	PixMapHandle destPixMap = GetGWorldPixMap(theDestination);	
	canLockPixels = LockPixels(destPixMap);

    // If the window is double buffered, call LockPortBits
    // to draw to the back buffer.
    /*
    OSErr lockPortBitsError;
    if (QDIsPortBuffered(theDestination)) {
        lockPortBitsError = LockPortBits(theDestination);
    }
    */
    
	// Draw from the offscreen GWorld to the window
	if (canLockPixels){	
		// Source and destination rectangles and drawingMode 
		// are data members of the Blitter class.
		CopyBits(GetPortBitMapForCopyBits(theSource), GetPortBitMapForCopyBits(theDestination), 
			&sourceRect, &destinationRect, drawingMode, nil);
        UnlockPixels(destPixMap);
	}

    // If window is double buffered call UnlockPortBits()
    // to have the drawing appear on the screen.
    /*
    if (QDIsPortBuffered(theDestination)) {
        lockPortBitsError = UnlockPortBits(theDestination);
    }
    */
    
	// restore graphics port and GDevice
	SetGWorld(oldPort, oldGDevice);

}

void Blitter::DrawImageToScreen(void)
{
	// Make sure the source and destination buffers exist.
	CGrafPtr theSource = GetSourceBuffer();
	CGrafPtr theDestination = GetDestinationBuffer();
	if ((theSource == nil) || (theDestination == nil))
		return;
		
	CGrafPtr oldPort;
	GDHandle oldGDevice;

	// Save previous drawing area
	GetGWorld (&oldPort, &oldGDevice);

	// Set drawing area to the screen
	SetGWorld (theDestination, GetMainDevice());
	
	// Lock the pixels
	PixMapHandle thePixMap = GetGWorldPixMap(theSource);	
	Boolean canLockPixels = LockPixels(thePixMap);
	
	// Draw from the offscreen GWorld to the window
	if (canLockPixels){	
		// Source and destination rectangles and drawingMode 
		// are data members of the Blitter class.  
		CopyBits(GetPortBitMapForCopyBits(theSource),
                GetPortBitMapForCopyBits(theDestination), 
                &sourceRect, &destinationRect, drawingMode, nil);
        UnlockPixels(thePixMap);
	}

	// OS X windows are double buffered.  We check if the destination
	// is double buffered.  If so, we flush the port buffer so the 
	// drawing will show on the screen in OS X.
 	/*
    RgnHandle theDirtyRegion;
	
	if (QDIsPortBuffered(theDestination)) {
        theDirtyRegion = NewRgn();	
        RectRgn(theDirtyRegion, &destinationRect);
		QDFlushPortBuffer(theDestination, theDirtyRegion);
        DisposeRgn(theDirtyRegion);
	}
	*/
    
	// restore graphics port and GDevice
	SetGWorld(oldPort, oldGDevice);

}

void Blitter::FlushBackBuffer(void)
{	
	// OS X windows are double buffered.  We check if the destination
	// is double buffered.  If so, we flush the port buffer so the 
	// drawing will show on the screen in OS X.
	if (QDIsPortBuffered(destinationBuffer)) {
		QDFlushPortBuffer(destinationBuffer, nil);//theDirtyRegion);
	}
	
}


