// AnimationController.h	by Mark Szymczyk
// Book version

#ifndef GAME_SPRITE
	#include "GameSprite.h"
#endif

// We need the InputController class to
// get the movements to handle.
#ifndef INPUT_CONTROLLER
	#include "InputController.h"
#endif

#define ANIMATION_CONTROLLER


class AnimationController
{
	protected:
		GameSpritePtr modelToControl;

	public:
		AnimationController();
		virtual ~AnimationController(void);

		// Accessors
		GameSpritePtr GetModelToControl(void); 			
		void SetModelToControl(GameSpritePtr theModel); 	


		// Functions to handle animation (movement and fighting)
		virtual void UpdateAnimation(InputControllerAction theAction);
        virtual void HandleMovement(SpriteDirection currentDirection);
		virtual void HandleMoveUp(void);
		virtual void HandleMoveDown(void);
		virtual void HandleMoveLeft(void);
		virtual void HandleMoveRight(void);
		virtual void HandleAttack(void);
		virtual void HandleStand(void);
	
		// Stuff I don't know how to group yet
		virtual void ChangeDirection (SpriteDirection newDirection);
		void MoveToNextFrame(void);
		
		// utility functions
		Boolean CurrentlyFighting(void);
        Boolean CurrentlyMoving(void);
        Boolean CanBeDrawn(GameLevelPtr theLevel);
		Boolean IsInScreenArea(void);
		
};
	

typedef AnimationController* AnimationControllerPtr;
typedef AnimationController** AnimationControllerHandle;

// Constants
