// AIController.h	by Mark Szymczyk

#ifndef __CARBON__
    #include <Carbon/Carbon.h>
#endif

#ifndef GAME_ENEMY
	#include "GameEnemy.h"
#endif

#ifndef FINITE_STATE_MACHINE
    #include "FiniteStateMachine.h"
#endif

/*
#ifndef PATHFINDER
    #include "Pathfinder.h"
#endif
*/

#ifndef INPUT_CONTROLLER
	#include "InputController.h"
#endif

#ifndef PHYSICS_CONTROLLER
	#include "PhysicsController.h"
#endif

#define AI_CONTROLLER

class AIController
{
	protected:
		GameEnemyPtr modelToControl;
		FiniteStateMachine decisionMaker;
		
        // We don't have pathfinding in this example.
        // We will remove the comments in Chapter 13.
        //Pathfinder pathMaker;
        
    public:
        // Constructor and destructor
        AIController(void);
        virtual ~AIController(void);
        
        // Accessors
        GameEnemyPtr GetModelToControl(void);
        void SetModelToControl(GameEnemyPtr theModel);
        
        FiniteStateMachine GetDecisionMaker(void);
        void SetDecisionMaker(FiniteStateMachine theDecisionMaker);
        
        //Pathfinder GetPathMaker(void);
        //void SetPathMaker(Pathfinder thePathMaker);

		// State machine related functions
		void BuildDecisionMaker(void);
		void HandleStateTransition(StateTransitionType theTransition);
        
        // Performing AI maneuvers
		virtual InputControllerAction PerformManeuver(short playerX, short playerY, 
                GameLevelPtr theLevel, GameTileListPtr theTiles);
        InputControllerAction MoveModel(short goalX, short goalY);
        InputControllerAction MoveModelAway(short goalX, short goalY);
        InputControllerAction Chase(short preyX, short preyY, 
                GameLevelPtr theLevel, GameTileListPtr theTiles);
        InputControllerAction Flee(short preyX, short preyY, 
                GameLevelPtr theLevel, GameTileListPtr theTiles);
                
        // Patrolling functions
		InputControllerAction Patrol(void);
		InputControllerAction PatrolUp(void);
		InputControllerAction PatrolDown(void);
		InputControllerAction PatrolLeft(void);
		InputControllerAction PatrolRight(void);
        
        // Utility functions
        Boolean CanAttack(short preyX, short preyY);
        InputControllerAction TurnLeft(void);
        InputControllerAction TurnRight(void); 
        Boolean IsInViewRect(short x, short y);       
        Boolean IsInPatrolArea(short x, short y, Rect patrolArea);
};

typedef AIController* AIControllerPtr;
typedef AIController** AIControllerHandle;

// Constants
const short kBufferZone = 4;

const short kNumberOfPatrollingTransitions = 2;
const short kNumberOfStandingTransitions = 2;
const short kNumberOfChasingTransitions = 2;
const short kNumberOfFleeingTransitions = 2;
