/*
 *  GameTexture.h
 *  MGPCode(OpenGL)
 *
 *  Created by Mark Szymczyk.
 *  Copyright 2005 Me and Mark Publishing. All rights reserved.
 *
 */

#include <Carbon/Carbon.h>
#include <OpenGL/gl.h>
#include <QuickTime/Movies.h>
#include <QuickTime/QuickTimeComponents.h>


#define GAME_TEXTURE

class GameTexture
{
    protected:
        int width;
        int height;
        
        // These members are parameters to the OpenGL
        // function glTexImage2D()
        GLint internalFormat;
        GLenum format;
        GLenum type;

        Ptr imageData;
        static GLuint textureObjectList;
        GWorldPtr offscreenBuffer;
        
    public:
        // Constructor
        GameTexture(void);
        
        // Destructor
        virtual ~GameTexture(void);
        
        // Accessors
        int GetWidth(void);
        void SetWidth(int theWidth);
        
        int GetHeight(void);
        void SetHeight(int theHeight);
        
        GLint GetInternalFormat(void);
        void SetInternalFormat(GLint theFormat);
        
        GLenum GetFormat(void);
        void SetFormat(GLenum theFormat);

        GLenum GetType(void);
        void SetType(GLenum theType);

        Ptr GetImageData(void);
        void SetImageData(Ptr theData);
        
        // Functions for loading a texture from a file
        void Load(CFStringRef filename, CFStringRef extension, CFStringRef subdirectory);
        void ReadFromFile(CFStringRef filename, CFStringRef extension, CFStringRef subdirectory);
        void Create(void);
                            
        // Drawing functions
        void Draw(void);
};

typedef GameTexture* GameTexturePtr;
typedef GameTexture** GameTextureHandle;

