/*
 *  GameApp.h
 *  
 *
 *  Created by Mark Szymczyk
 *  Copyright (c) 2005 Me and Mark Publishing. All rights reserved.
 *
 */

#include <Carbon/Carbon.h>
#include <AGL/agl.h>
#include <OpenGL/gl.h>

#ifndef GAME_TEXTURE
    #include "GameTexture.h"
#endif

class GameApp
{
	protected:
        AGLContext drawContext;
        EventLoopTimerUPP gameTimer;
        EventLoopTimerRef timer;
        GameTexture textureMap;
        
	public:
		GameApp (void);
		virtual ~GameApp(void);
		void InitApp(void);
		void EventLoop(void);
		void CleanUpApp(void);

		// Initialization functions
		void InitToolbox (void);
        void InitializeAGL(void);
		void SetUpMenuBar(void);
        void RegisterMenuCommands(void);
        void InstallKeyboardEventHandler(void);
        void InstallTimer(void);

		// menu related functions
		static pascal OSStatus MenuEventHandler(EventHandlerCallRef myHandlerChain,
                EventRef event, void* userData);
		virtual void Quit(void);


		// Game related functions
		static pascal void GameLoopTimer(EventLoopTimerRef theTimer, void* userData);
        static pascal OSStatus KeyboardEventHandler(EventHandlerCallRef myHandlerChain,
                                                EventRef event, void* userData);
		void GameLoop(void);
		void RenderFrame(void);
		void Pause(void);
		void Resume(void);
};

typedef GameApp* GameAppPtr;
typedef GameApp** GameAppHandle;


// constants for the menus and menu items

const short kMenuBarID = 128;

const short kAppleMenu = 128;
const short kAbout		= 1;

const short kFileMenu = 129;
// element 2 is a line separator
const short kResumeMenuItem = 	1;
const short kFileMenuDivider = 2;
const short	kQuitMenuItem = 	3;		
const short kResumeTextID = 128;

// Keyboard constants
const short kEscapeKey = 0x35;
const short kQuitKey = 0x0C00;

const char kLetterQ = 'Q';

const Boolean kUseVirtualKeyCode = true;
const Boolean kDontUseVirtualKeyCode = false;

const MenuCommand kCommandResumeGame = FOUR_CHAR_CODE('Rsum');
const short kEventTotal = 1;
const short kKeyboardEventTotal = 1;

const short k16BitColor = 16;
const short k32BitColor = 32;

const short kSingleBuffered = 1;
const short kDoubleBuffered = 2;

